/*
Version: 1.0, requires Writemonkey 2.7.0.0 or higher

Release date: September 8th 2014

Author: Josip

Description: 
Scratch pad plugin integrates seamlessly into the wm's "scratch mode" and offers you National velocity / Resoph notes like friction-free notes creation. 

Installation:
Unzip the "Scratch pad" directory into the plugins directory.

Deployment:
This plugin is initialized at startup. 
*/


monkey.include("_config.incl");
monkey.include("_config_user.incl");
monkey.include("_util.incl");
monkey.include("Logic.incl");
monkey.include("Db.incl");

// Database
var db = new Database();
db._init();

// Get general data
var generalData = db.getGeneralData();


// GLobals / flags
var appLoaded = false;
var pluginActive = false;
var loadedItem = null;
var previousItem = null;
var loadedHash = "0";
var alpha_sorting = generalData.alpha_sorting;
var wordsSum = 0;
var activeWidth = 0;
var activeHeight = 0;
var isMinimized = false;


// Colors used
var bC = getColorFromName(BACKGROUND_COLOR);
var fC = getColorFromName(FOREGROUND_COLOR);


/*
##     ##  ####  
##     ##   ##   
##     ##   ##   
##     ##   ##   
##     ##   ##   
##     ##   ##   
 #######   ####  
*/

// Plugin form
var pluginForm = monkey.getBlankPluginForm(400, 600);
var listView = monkey.getBlankListView();
var tableLayoutPanel1 = new System.Windows.Forms.TableLayoutPanel();
var panel1 = new System.Windows.Forms.Panel();
var panel2 = new System.Windows.Forms.Panel();
var blankPanel = new System.Windows.Forms.Panel();
var textBox1 = new System.Windows.Forms.TextBox();
var clearLabel = new System.Windows.Forms.Label();
var minimizeLabel = new System.Windows.Forms.Label(); minimizeLabel.Visible = false;
var newLabel = new System.Windows.Forms.Label();
var deleteLabel = new System.Windows.Forms.Label();
var optionsLabel = new System.Windows.Forms.Label();
var optionsContextMenuStrip = new System.Windows.Forms.ContextMenuStrip();
var filterContextMenuStrip = new System.Windows.Forms.ContextMenuStrip();

// Filter context menu
filterContextMenuStrip.ShowImageMargin = false;
filterContextMenuStrip.ShowShortcutKeys = false;
filterContextMenuStrip.Font = new System.Drawing.Font(UI_FONT_NAME, filterContextMenuStrip.Font.Size, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point);


// Options context menu
optionsContextMenuStrip.ShowImageMargin = false;
optionsContextMenuStrip.ShowShortcutKeys = false;
optionsContextMenuStrip.Font = new System.Drawing.Font(UI_FONT_NAME, optionsContextMenuStrip.Font.Size, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point);

var changeSortingMenuItem = new System.Windows.Forms.ToolStripMenuItem((alpha_sorting == 0) ? SORT_ALPHABETICALLY_S : SORT_BY_LAST_CHANGE);
changeSortingMenuItem.Tag = "cs";
optionsContextMenuStrip.Items.Add(changeSortingMenuItem);

var separator = new System.Windows.Forms.ToolStripSeparator();
optionsContextMenuStrip.Items.Add(separator);

var changeDatabaseMenuItem = new System.Windows.Forms.ToolStripMenuItem(CHANGE_DATABASE_MENU_S);
changeDatabaseMenuItem.Tag = "chd";
optionsContextMenuStrip.Items.Add(changeDatabaseMenuItem);

var newDatabaseMenuItem = new System.Windows.Forms.ToolStripMenuItem(NEW_DATABASE_MENU_S);
newDatabaseMenuItem.Tag = "nd";
optionsContextMenuStrip.Items.Add(newDatabaseMenuItem);

var compactDatabaseMenuItem = new System.Windows.Forms.ToolStripMenuItem(COMPACT_DATABASE_MENU_S);
compactDatabaseMenuItem.Tag = "cd";
optionsContextMenuStrip.Items.Add(compactDatabaseMenuItem);



pluginForm.Padding = new System.Windows.Forms.Padding(10);
pluginForm.BackColor = bC;
pluginForm.deactivatedOpacity = DEACTIVATED_OPACITY;
pluginForm.showMinimizeButton = false;
pluginForm.mouseCapturing = false;
pluginForm.MinimumSize = new System.Drawing.Size(100, 95);
pluginForm.roundedCorners = ROUNDED_CORNERS;

tableLayoutPanel1.BackColor = bC;
tableLayoutPanel1.ColumnCount = 1;
tableLayoutPanel1.ColumnStyles.Add(new System.Windows.Forms.ColumnStyle(System.Windows.Forms.SizeType.Percent, 100));
tableLayoutPanel1.Controls.Add(listView, 0, 2);
tableLayoutPanel1.Controls.Add(panel1, 0, 0);
tableLayoutPanel1.Controls.Add(panel2, 0, 3);
tableLayoutPanel1.Dock = System.Windows.Forms.DockStyle.Fill;
tableLayoutPanel1.Location = new System.Drawing.Point(10, 10);
tableLayoutPanel1.Margin = new System.Windows.Forms.Padding(0);
tableLayoutPanel1.RowCount = 4;
tableLayoutPanel1.RowStyles.Add(new System.Windows.Forms.RowStyle(System.Windows.Forms.SizeType.Absolute, 30));
tableLayoutPanel1.RowStyles.Add(new System.Windows.Forms.RowStyle(System.Windows.Forms.SizeType.Absolute, 8));
tableLayoutPanel1.RowStyles.Add(new System.Windows.Forms.RowStyle(System.Windows.Forms.SizeType.Percent, 100));
tableLayoutPanel1.RowStyles.Add(new System.Windows.Forms.RowStyle(System.Windows.Forms.SizeType.Absolute, 30));
tableLayoutPanel1.Size = new System.Drawing.Size(251, 372);
tableLayoutPanel1.TabIndex = 0;


listView.backColor = bC;
listView.foreColor = fC;
listView.Dock = System.Windows.Forms.DockStyle.Fill;
listView.HideSelection = false;
listView.Font = new System.Drawing.Font(LIST_FONT_NAME, TEXT_SIZE, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point);
listView.Padding = new System.Windows.Forms.Padding(0);
listView.BackColor = bC;
listView.FullRowSelect = true;
listView.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.None;
listView.HotTracking = false;
listView.HoverSelection = false;
listView.MultiSelect = false;
listView.ShowItemToolTips = SHOW_TOOLTIPS;

listView.Columns.Add("#1", 150, System.Windows.Forms.HorizontalAlignment.Right);
listView.Columns.Add("#2", 25, System.Windows.Forms.HorizontalAlignment.Left);
listView.Columns.Add("#3", 70, System.Windows.Forms.HorizontalAlignment.Right);
listView.Columns.Add("#4", 40, System.Windows.Forms.HorizontalAlignment.Right);

panel1.BackColor = fC;
panel1.Dock = System.Windows.Forms.DockStyle.Fill;
panel1.Location = new System.Drawing.Point(0, 0);
panel1.Margin = new System.Windows.Forms.Padding(0);
panel1.Padding = new System.Windows.Forms.Padding(0);
// panel1.Name = "panel1";
// panel1.Size = new System.Drawing.Size(0, 0);

panel2.BackColor = bC;
panel2.Dock = System.Windows.Forms.DockStyle.Fill;
panel2.Location = new System.Drawing.Point(0, 0);
panel2.Margin = new System.Windows.Forms.Padding(0);
panel2.Padding = new System.Windows.Forms.Padding(0);
// panel2.Size = new System.Drawing.Size(0, 0);

textBox1.BackColor = fC;
textBox1.ForeColor = bC;
textBox1.BorderStyle = System.Windows.Forms.BorderStyle.None;
textBox1.Font = new System.Drawing.Font(UI_FONT_NAME, 10, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point);
textBox1.Location = new System.Drawing.Point(10, 7);
// textBox1.Name = "textBox1";
textBox1.Size = new System.Drawing.Size(panel1.Width - 50, 17);
textBox1.ContextMenuStrip = new System.Windows.Forms.ContextMenuStrip();
textBox1.AcceptsTab = true;
textBox1.TabIndex = 0;


clearLabel.ForeColor = bC;
clearLabel.Anchor = System.Windows.Forms.AnchorStyles.Right;
clearLabel.AutoSize = true;
clearLabel.Location = new System.Drawing.Point(0, 0);
clearLabel.Size = new System.Drawing.Size(0, 0);
clearLabel.Font = new System.Drawing.Font(UI_FONT_NAME, 8, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point);
clearLabel.Cursor = System.Windows.Forms.Cursors.Hand;
clearLabel.TabIndex = 1;
clearLabel.Text = CLEAR_S;


minimizeLabel.AutoSize = false;
minimizeLabel.Font = new System.Drawing.Font("Arial", 9, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point);
minimizeLabel.Cursor = System.Windows.Forms.Cursors.Hand;
minimizeLabel.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
minimizeLabel.Dock = System.Windows.Forms.DockStyle.Fill;


newLabel.ForeColor = fC;
newLabel.Anchor = System.Windows.Forms.AnchorStyles.Right;
newLabel.AutoSize = true;
newLabel.Location = new System.Drawing.Point(0, 0);
newLabel.Size = new System.Drawing.Size(0, 0);
newLabel.Font = new System.Drawing.Font(UI_FONT_NAME, 12, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point);
newLabel.Cursor = System.Windows.Forms.Cursors.Hand;
newLabel.TabIndex = 1;
newLabel.Text = NEW_S;


deleteLabel.ForeColor = fC;
deleteLabel.Anchor = System.Windows.Forms.AnchorStyles.Right;
deleteLabel.AutoSize = true;
deleteLabel.Location = new System.Drawing.Point(0, 0);
deleteLabel.Size = new System.Drawing.Size(0, 0);
deleteLabel.Font = new System.Drawing.Font(UI_FONT_NAME, 12, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point);
deleteLabel.Cursor = System.Windows.Forms.Cursors.Hand;
deleteLabel.TabIndex = 1;
deleteLabel.Text = DELETE_S;


optionsLabel.ForeColor = fC;
optionsLabel.Anchor = System.Windows.Forms.AnchorStyles.Left;
optionsLabel.AutoSize = true;
optionsLabel.Location = new System.Drawing.Point(0, 0);
optionsLabel.Size = new System.Drawing.Size(0, 0);
optionsLabel.Font = new System.Drawing.Font(UI_FONT_NAME, 10.3, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point);
optionsLabel.Cursor = System.Windows.Forms.Cursors.Hand;
optionsLabel.TabIndex = 1;
optionsLabel.Text = OPTIONS_S;



pluginForm.Controls.Add(tableLayoutPanel1);
pluginForm.Controls.Add(minimizeLabel);
pluginForm.Controls.Add(blankPanel);
panel1.Controls.Add(clearLabel);
panel1.Controls.Add(textBox1);
panel2.Controls.Add(newLabel);
panel2.Controls.Add(deleteLabel);
panel2.Controls.Add(optionsLabel);


positionElements();
colorElements();
// END UI //


// update filter box on first time
textBox1.Text = generalData.filter_text;


/*
########   ##     ##  ########   ##    ##   ########    ######    
##         ##     ##  ##         ###   ##      ##      ##    ##   
##         ##     ##  ##         ####  ##      ##      ##         
######     ##     ##  ######     ## ## ##      ##       ######    
##          ##   ##   ##         ##  ####      ##            ##   
##           ## ##    ##         ##   ###      ##      ##    ##   
########      ###     ########   ##    ##      ##       ######    
*/

monkey.form.add_Click(function(object, eventargs) {

});


pluginForm.add_DoubleClick(function(object, eventargs) {
	minimizePlugin();
});


monkey.richTextBox.add_KeyDown(function(object, eventargs) {
	if (eventargs.KeyCode == System.Windows.Forms.Keys.D4 && System.Windows.Forms.Control.ModifierKeys == System.Windows.Forms.Keys.Control) {
		listView.Focus();
	}
});


pluginForm.add_Paint(function(object, eventargs) {
	if (pluginForm.BackColor == monkey.paperColor && BORDER_ON_SAME_BACKGROUND) {
		var rect = new System.Drawing.Rectangle(0, 0, pluginForm.Width - 2, pluginForm.Height - 2);
		var pen = new System.Drawing.Pen(fC, 1);
		pen.DashStyle = System.Drawing.Drawing2D.DashStyle.Dot;
		eventargs.Graphics.DrawRectangle(pen, rect);
	}	
});


panel1.add_Paint(function(object, eventargs) {
	var pg = panel1.CreateGraphics();
	//pg.SmoothingMode = System.Drawing.Drawing2D.SmoothingMode.AntiAlias;
	var pen = new System.Drawing.Pen(fC, 1);
	pen.DashStyle = System.Drawing.Drawing2D.DashStyle.Dot;
	//pg.DrawRectangle(pen, rect);
	pg.DrawLine(pen, 1, panel1.Height - 1, panel1.Width -1 , panel1.Height -1 );
	pg.Dispose();
});


// Will handle file name changes and deactivate plugin if not in scratch mode
// This event can fire redundantly
monkey.form.add_FileNameChanged(function(object, eventargs) {
	if (monkey.fileHolder != "-1" && pluginForm.Visible == true) {
		// monkey.playSound();
		db.updateItem(loadedItem);
		deactivateScratch();
	}
});

// Will handle new file (scratch) command and will create new blank note
monkey.richTextBox.add_NewScratch(function(object, eventargs) {
	if (monkey.fileHolder == "-1") {
		// create Blank if requested from scratch
		if (pluginForm.Visible) {
			setNewItem(true); // true = skip update
		} else { // open plugin ui and load last
			activateScratch();
			loadedItem = null;
			updateListView(false);
		}
	}
});

// Will listen for save command and cancel if in scratch mode
monkey.add_beforeSaveE(function(object, eventargs) {
	if (monkey.fileHolder == "-1") {
		eventargs.cancel = true;
		db.updateItem(loadedItem);

		updateListView(true);
	}
});

// On focus
pluginForm.add_Activated(function(object, eventargs) {
	blankPanel.Visible = false;
});

// On lost focus
pluginForm.add_Deactivate(function(object, eventargs) {
	blankPanel.BackColor = bC;
	blankPanel.SetBounds(listView.Right - System.Windows.Forms.SystemInformation.VerticalScrollBarWidth + 4, listView.Location.Y + 4, System.Windows.Forms.SystemInformation.VerticalScrollBarWidth + 10, listView.Height + 10);
	if (minimizeLabel.Visible == false) blankPanel.Visible = true;
	blankPanel.BringToFront();
});

listView.add_DoubleClick(function(object, eventargs) {
	db.updateLastUpdate(listView.SelectedItems[0]);
	updateListView(true);
});

pluginForm.add_MouseDown(function(object, eventargs) {

});

pluginForm.add_MouseUp(function(object, eventargs) {

});

pluginForm.add_SizeChanged(function(object, eventargs) {
	positionElements();
});

monkey.richTextBox.add_ForeColorChanged(function(object, eventargs) {
	colorElements();
});

textBox1.add_TextChanged(function(object, eventargs) {
	if (textBox1.Text.Length != 1) {
		if (updateNeeded()) {
			db.updateItem(loadedItem);
		}
		updateListView(true);
	}
});


textBox1.add_MouseDown(function(object, eventargs) {
	if (eventargs.Button == System.Windows.Forms.MouseButtons.Right) {
		setFilterBoxContextMenu();
		filterContextMenuStrip.Show(new System.Drawing.Point(System.Windows.Forms.Cursor.Position.X, System.Windows.Forms.Cursor.Position.Y));
	}
});



monkey.richTextBox.add_TextChanged(function(object, eventargs) {

});

clearLabel.add_Click(function(object, eventargs) {
	textBox1.Clear();
});


newLabel.add_Click(function(object, eventargs) {
	setNewItem(false);
});

deleteLabel.add_Click(function(object, eventargs) {
	deleteItem();
});

optionsLabel.add_Click(function(object, eventargs) {
	optionsContextMenuStrip.Show(new System.Drawing.Point(System.Windows.Forms.Cursor.Position.X, System.Windows.Forms.Cursor.Position.Y));
});


minimizeLabel.add_Click(function(object, eventargs) {
	maximizePlugin();
});


listView.add_ItemSelectionChanged(function(object, eventargs) {
	if (!eventargs.IsSelected && updateNeeded() && monkey.document.Length > 0) {
		previousItem = eventargs.Item;
		db.updateItem(eventargs.Item);
	} else if (eventargs.IsSelected && loadedItem.Tag != eventargs.Item.Tag) {
		try {
			setItemFromId(eventargs.Item);
		} catch (e) {

		}
	}
});


listView.add_ItemActivate(function(object, eventargs) {
	monkey.richTextBox.Focus();
});


listView.add_SelectedIndexChanged(function(object, eventargs) {

});

// Manage soft exit
monkey.form.add_VisibleChanged(function(object, eventargs) {
	// if (monkey.form.Visible == false && appLoaded) {
	// 	pluginForm.Hide();
	// } else {
	// 	pluginForm.Show();
	// }
});


// Save active on exit
monkey.add_appClosingE(function(object, eventargs) {
	// Store general data
	db.setGeneralData();
});


monkey.add_beforeOpenE(function(object, eventargs) {

	if (monkey.fileHolder == "-1" && pluginForm.Visible == true) {
		db.updateItem(loadedItem);
		maximizePlugin();
	}

	if (System.IO.Path.GetExtension(eventargs.beforeOpenFileHolder) == "." + DATABASE_EXTENSION) {
		eventargs.cancel = true;
		openDatabase(eventargs.beforeOpenFileHolder);

		if (monkey.fileHolder != "-1") { // handle 
			monkey.goFromScratch();
		} else {
			updateListView(false);
		}
		return eventargs;
	}
});



// Initialize plugin on startup
// ENTRY POINT
monkey.add_appLoadedE(function(object, eventargs) {
	appLoaded = true;
	// show on start if scratch
	if (monkey.fileHolder == "-1") {
		textBox1.Text = generalData.filter_text;
		activateScratch();
	}
});



/*
##    ##   ########   ##    ##   ########    #######      ###     ########   ########   
##   ##    ##          ##  ##    ##     ##  ##     ##    ## ##    ##     ##  ##     ##  
##  ##     ##           ####     ##     ##  ##     ##   ##   ##   ##     ##  ##     ##  
#####      ######        ##      ########   ##     ##  ##     ##  ########   ##     ##  
##  ##     ##            ##      ##     ##  ##     ##  #########  ##   ##    ##     ##  
##   ##    ##            ##      ##     ##  ##     ##  ##     ##  ##    ##   ##     ##  
##    ##   ########      ##      ########    #######   ##     ##  ##     ##  ########   
*/


listView.add_KeyDown(function(object, eventargs) {
	if (eventargs.KeyCode == System.Windows.Forms.Keys.Delete) {
		deleteItem();
	} else if (System.Windows.Forms.Control.ModifierKeys == System.Windows.Forms.Keys.Control && (eventargs.KeyCode == System.Windows.Forms.Keys.D0 || eventargs.KeyCode == System.Windows.Forms.Keys.Delete)) {
		textBox1.Clear();
	} else if (eventargs.KeyCode == System.Windows.Forms.Keys.Up) {
		if (listView.Items[0].Selected == true) {
			textBox1.Focus();
		}
	}
});

textBox1.add_KeyDown(function(object, eventargs) {
	if (System.Windows.Forms.Control.ModifierKeys == System.Windows.Forms.Keys.Control && (eventargs.KeyCode == System.Windows.Forms.Keys.D0 || eventargs.KeyCode == System.Windows.Forms.Keys.Delete)) {
		textBox1.Clear();
	} else if (eventargs.KeyCode == System.Windows.Forms.Keys.Enter) {
		setFilterBoxContextMenu();
		filterContextMenuStrip.Show(new System.Drawing.Point(textBox1.Location.X + textBox1.Width, textBox1.Location.Y));
	} else if (eventargs.KeyCode == System.Windows.Forms.Keys.Down) {
		listView.Focus();
	}
});


/*
##     ##  ########   ##    ##   ##     ##  
###   ###  ##         ###   ##   ##     ##  
#### ####  ##         ####  ##   ##     ##  
## ### ##  ######     ## ## ##   ##     ##  
##     ##  ##         ##  ####   ##     ##  
##     ##  ##         ##   ###   ##     ##  
##     ##  ########   ##    ##    #######   
*/

optionsContextMenuStrip.add_ItemClicked(function(object, eventargs) {
	// update
	db.updateItem(loadedItem);
	optionsContextMenuStrip.Hide();

	if (eventargs.ClickedItem.Tag == "cd") {
		compactDatabase();
	} else if (eventargs.ClickedItem.Tag == "cs") {
		if (alpha_sorting == 0) {
			alpha_sorting = 1;
			changeSortingMenuItem.Text = SORT_BY_LAST_CHANGE;
		} else {
			alpha_sorting = 0;
			changeSortingMenuItem.Text = SORT_ALPHABETICALLY_S;
		}
		updateListView(true);
	} else if (eventargs.ClickedItem.Tag == "chd") {
		changeDtabase();
	} else if (eventargs.ClickedItem.Tag == "nd") {
		createBlankDb();
	}
});


filterContextMenuStrip.add_ItemClicked(function(object, eventargs) {
	insertTagInFilterBox(eventargs.ClickedItem.Text);
});